<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model 
{

    protected $table = 'tickets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'user_id', 'last_replied_at', 'last_seen_at', 'subject');
    protected $visible = array('order_id', 'user_id', 'last_replied_at', 'last_seen_at', 'subject');

    public function message()
    {
        return $this->hasOne('TicketMessage');
    }

}